#ifndef EXTAPP_MNG_H_
#define EXTAPP_MNG_H_



/*This function configure the SEP timer                              */
/*The function parameters:                                           */
/*TimeInKTicks - The time in kTicks. It is done because the timer    */
/*is set in ticks and not seconds and in order to give a larger      */
/* range than 32 bit number                                          */
/* Any value other than 0x0 enables the timer, 0 disables the Timer  */
/* Since the counter has only 32 bit register for value the software */
/* is implementing a software counter that works in larger range     */

DxUint32_t DX_SEP_MNG_TimerConfigure(DxUint32_t TimeInKTicks);

/**************************************************************/
/* This function allows the external application to configure */
/* Direct Data Access register in order to access different   */
/* External memories ranges                                   */
/* Parameters:												  */
/* PeripheralAddr - Full physical address of the pheripgral   */
/* Area.                                                      */
/* The function get absolute address and return the SEP mapped*/
/* address                                                    */
/**************************************************************/
DxUint8_t * DX_SEP_MNG_SetExtMemAccess (DxUint32_t PeripheralAddr );

typedef enum
{
	DX_SEP_EXTAPP_SJTAG_KEY_TYPE,
	DX_SEP_EXTAPP_OEM_KEY_TYPE,
	DX_SEP_EXTAPP_EXT1_TYPE,
	DX_SEP_EXTAPP_EXT2_TYPE,
	DX_SEP_EXTAPP_EXT3_TYPE,
	DX_SEP_EXTAPP_EXT4_TYPE,
	DX_SEP_EXTAPP_LastKey       = 0x7FFFFFFF,	
}DX_SEP_EXTAPP_OTP_KEY_TYPES;

/**************************************************************/
/* This functions copies one of the verifications keys to the */
/* user buffer.                                               */
/**************************************************************/
DxUint32_t DX_SEP_GetVerificationOTPKey(DX_SEP_EXTAPP_OTP_KEY_TYPES keyIndex, DxUint8_t    *KeyBuffer_ptr, DxUint32_t KeyBufferLen);

/*****************************************************************/
/* This functions send ack signal from the Discretix application */
/*****************************************************************/

DxUint32_t DX_SEP_SendExtIntAck(void);

/**********************************************/
/* The function returns the LCS               */
/**********************************************/
DxError_t DX_MNG_GetLCS(DxUint32_t    *LCS_ptr);

/*****************************************************************/
/* The function returns the Dx SST workspace address and size    */
/* Parameters:                                                   */
/* DxByte_t   **aWorkspace_ptr - buffer for the address.         */
/* DxUint32_t *aWorkspaceSizeInBytes_ptr - buffer for the size   */
/*****************************************************************/
DxError_t DX_SEP_MNG_SSTGetWorkspaceParams(DxByte_t			**aWorkspace_ptr,
										   DxUint32_t		*aWorkspaceSizeInBytes_ptr);


/*****************************************************************/
/* The function is used to read the caller ID from HOST memory   */
/* Parameters:                                                   */
/* DxByte_t   * callerId_ptr - buffer for the address.           */
/* DxUint32_t  callerIdLen - buffer for the size                 */
/*****************************************************************/
DxUint32_t DX_SEP_GetCallerId(DxUint8_t *callerId_ptr, DxUint32_t callerIdLen);

/*
*   @brief This function is used for reseting and configuring the 3 cache counters. 
*   Each counter can be one of the 9 options defined in the enumerator DX_CC_MNG_CacheCounterType_t.       
*
*   @param[in] cfgCnt1 - cache counter configuration for counter1. 
*   @param[in] cfgCnt2 - cache counter configuration for counter2. 
*   @param[in] cfgCnt3 - cache counter configuration for counter3. 
*   Returns:  Status of the operation.
*/
/*
*   @brief This enum defines the different cache counters
*          
*/
typedef enum
{
	DX_CC_MNG_COUNTER_TYPE_TOTAL_HIT = 0,
	DX_CC_MNG_COUNTER_TYPE_TOTAL_OPERATIONS = 1,
	DX_CC_MNG_COUNTER_TYPE_TOTAL_FLUSH = 2,
	DX_CC_MNG_COUNTER_TYPE_RD_HIT = 3,
	DX_CC_MNG_COUNTER_TYPE_RD_OPERATIONS = 4,
	DX_CC_MNG_COUNTER_TYPE_RD_FLUSH = 5,
	DX_CC_MNG_COUNTER_TYPE_WR_HIT = 6,
	DX_CC_MNG_COUNTER_TYPE_WR_OPERATIONS = 7,
	DX_CC_MNG_COUNTER_TYPE_WR_FLUSH = 8,
	DX_CC_MNG_COUNTER_TYPE_MAX_CONIG_TYPE = 0x7FFFFFFF
}DX_CC_MNG_CacheCounterConfigType_t;

/*
*   @brief This enum defines the different cache type
*          
*/
typedef enum
{
	DX_CC_MNG_I_CACHE_COUNTER_TYPE = 0,
	DX_CC_MNG_D_CACHE_COUNTER_TYPE = 1,
	DX_CC_MNG_CACHE_COUNTER_TYPE_MAX_TYPE = 0x7FFFFFFF
}DX_CC_MNG_CacheCounterType_t;



/*
*   @brief This function is used for reseting and configuring the 3 cache counters. 
*   Each counter can be one of the 9 options defined in the enumerator DX_CC_MNG_CacheCounterType_t.       
*
*   @param[in] cfgCnt1 - cache counter configuration for counter1. 
*   @param[in] cfgCnt2 - cache counter configuration for counter2. 
*   @param[in] cfgCnt3 - cache counter configuration for counter3. 
*   Returns:  Status of the operation.
*/

DxError_t DX_CC_MNG_ConfigureAndResetCacheCounters(DX_CC_MNG_CacheCounterType_t       cacheType,
                                                   DX_CC_MNG_CacheCounterConfigType_t cfgCnt1,
                                                   DX_CC_MNG_CacheCounterConfigType_t cfgCnt2,
                                                   DX_CC_MNG_CacheCounterConfigType_t cfgCnt3);


/*
*   @brief This function is used for reading the 3 cache counters. 
*   The read is not reseting the counters so counter can be read few times        
*   during the tests flow without reconfiguration.
*
*
*   @param[in] cnt1Val - buffer for counter1. 
*   @param[in] cnt2Val - buffer for counter2. 
*   @param[in] cnt3Val - buffer for counter3. 
*   Returns:  Status of the operation.
*/

DxError_t DX_CC_MNG_GetCacheCounters(DX_CC_MNG_CacheCounterType_t       cacheType,
                                     DxUint32_t                         *cnt1Val,
                                     DxUint32_t                         *cnt2Val,
                                     DxUint32_t                         *cnt3Val);




#endif
